#!/bin/sh

SYNOINFO_DEF=/etc.defaults/synoinfo.conf
MIN_FREE_KBYTES=`/bin/get_key_value $SYNOINFO_DEF min_free_kbytes`
MEMTESTER_MIN_FREE_KBYTES=`/bin/get_key_value $SYNOINFO_DEF memtester_min_free_kbytes`
SupportRAID=`/bin/get_key_value /etc/synoinfo.conf supportraid`
if [ "$SupportRAID" = "yes" ]; then
	RootDevice=/dev/md0
else
	RootDevice=/dev/sda1
fi

eval $(grep "^HOSTNAME=" /.memtest)
if [ -n "$HOSTNAME" ]; then
	hostname $HOSTNAME
fi

SZF_MEM_LOG_ROOT="/mntmemtest"
SZF_MEM_PROGRESS="/tmp/memtester.progress"
SZF_MEM_VARLOG=${SZF_MEM_LOG_ROOT}"/var/log/memtester.log"

/bin/mkdir -p ${SZF_MEM_LOG_ROOT}
/bin/mount ${RootDevice} ${SZF_MEM_LOG_ROOT}
/bin/mkdir -p `dirname ${SZF_MEM_VARLOG}`
/bin/echo "0/0" > ${SZF_MEM_VARLOG}
/bin/umount ${SZF_MEM_LOG_ROOT}

if [ -n "$MEMTESTER_MIN_FREE_KBYTES" ]; then
	echo $MEMTESTER_MIN_FREE_KBYTES > /proc/sys/vm/min_free_kbytes;
fi

/usr/sbin/memtester -max 1 -full > /dev/null 2>&1
/bin/echo "ERROR=$?" >> ${SZF_MEM_PROGRESS}

if [ -n "$MIN_FREE_KBYTES" ]; then
	echo $MIN_FREE_KBYTES > /proc/sys/vm/min_free_kbytes;
fi

/bin/mount ${RootDevice} ${SZF_MEM_LOG_ROOT}
/bin/cp ${SZF_MEM_PROGRESS} ${SZF_MEM_VARLOG}
/bin/umount ${SZF_MEM_LOG_ROOT}


/bin/rmdir ${SZF_MEM_LOG_ROOT}
/sbin/reboot

