#!/bin/sh

HA_PREFIX="/usr/syno/synoha"
HA_STR=$HA_PREFIX"/sbin/synohastr"
HA_BIN=$HA_PREFIX"/sbin/synoha"

. $HA_PREFIX/etc.defaults/rc.subr

SZ_REBOOT=`$HA_STR --ais-reboot`
SZ_POWEROFF=`$HA_STR --ais-poweroff`
SZ_SYNOLOG_REQ=`$HA_STR --ais-synolog-req`
SZ_SYNOLOG_RESP=`$HA_STR --ais-synolog-resp`
SZ_INFOSET_REQ=`$HA_STR --ais-infoset-req`
SZ_PASSIVE_MAC=`$HA_STR --ais-passive-mac`

SYNO_UNBIND_WITH_REBOOT=`synohastr --unbind-with-reboot`
SYNO_REMOVED_FROM_HA=`synohastr --removed-from-ha`

log()
{
	echo "[$(/bin/date +%c)] $@" >> $HA_PREFIX/var/log/cluster/ais.action
}

if [ $# != 1 ]; then
	log "unknown file"
	return 1
fi

# $1 is a tmp file (name)
# first line is the message/header/command, others are the file content (if any)
# 1-8 bytes: header
header=`head -c 8 $1`

case "$header" in
	"STRUCT  ")
		log "[STRUCT] $1"
		{
			$HA_PREFIX/sbin/synodrbd --handle-ais-msg $1
		}&
		;;
#todo: handle reboot by cgi or something
	$SZ_REBOOT)
		log "[Reboot]"
		{
			sleep 3
			$HA_PREFIX/etc.defaults/rc.ha stop
			reboot
		}&
		;;
#todo: handle poweroff by cgi or something
	$SZ_POWEROFF)
		log "[Poweroff]"
		{
			sleep 3
			$HA_BIN --poweroff-ds
		}&
		;;
	$SZ_SYNOLOG_REQ)
		#log "[LogReq]"
		{
			$HA_BIN --receive-synolog-info $1
		}&
		;;
	$SZ_SYNOLOG_RESP)
		#log "[LogResp]"
		SZF_HA_TMP_SYNOLOG_RESP=`$HA_STR --ha-log-resp-result`
		echo `head -c 16 $1 | cut -b 9-16` > $SZF_HA_TMP_SYNOLOG_RESP
		;;
	$SZ_INFOSET_REQ)
		#log "[InfosetReq]"
		{
			$HA_BIN --receive-infoset $1
		}&
		;;
	"UNBIND  ")
		log "[Unbind]"
		{
			sleep 3
			$HA_PREFIX/sbin/synoha --unbind-local $SYNO_UNBIND_WITH_REBOOT "$SYNO_REMOVED_FROM_HA" &> /dev/null &
			# wait reboot after unbind local
			sleep 300
			reboot -f
		}&
		;;
	"SAVE_KEY")
		log "[Save_key]"
		{
			$HA_PREFIX/sbin/synoha --auth-key `cat $1`
		}&
		;;
	"SHUTBEEP")
		log "[Shut_Beep]"
		{
			$HA_PREFIX/sbin/synoha --stop-beep
		}&
		;;
	"CONF_CHG")
		log "[SYNOINFO_CHANGE]"
		{
			$HA_PREFIX/sbin/synoha --signal-scemd synoinfo-change
		}&
		;;
	"UPGRADE ")
		# the same as ha_upgrade.cc
		# MUST change them both
		log "[Upgrade]"
		SZF_HA_UPG_INFO=`$HA_STR --ha-upgrade-info`
		SZF_HA_UPG_INFO_TMP="$SZF_HA_UPG_INFO.tmp"
		SZK_HA_UPG_PROGRESS="progress"
		# Reference the struct HA_AIS_UPG_HEADER with member "mark", "cmd", and "data"
		cmd=`head -c 16 $1 | cut -b 9-16`
		data=`cat $1 | cut -b 17-48`
		case "$cmd" in
			"DONE_ACT"|"DONE_PAS"|"FAIL_ACT"|"FAIL_PAS"|"ERR_PASS")
				log "[upg result $cmd]"
				if [ "$cmd" == "ERR_PASS" -a "$data" != "" ]; then
					echo "$data" > "/tmp/update.progress"
				fi
				sed "/$SZK_HA_UPG_PROGRESS/d" $SZF_HA_UPG_INFO > $SZF_HA_UPG_INFO_TMP
				if [ -s $SZF_HA_UPG_INFO_TMP ]; then
					echo "$SZK_HA_UPG_PROGRESS=$cmd" >> $SZF_HA_UPG_INFO_TMP
					mv $SZF_HA_UPG_INFO_TMP $SZF_HA_UPG_INFO
				fi
				;;
			"START   ")
				log "[upg start]"
				$HA_PREFIX/sbin/synoha --upg-start &
				;;
			*)
			log "unknown cmd: $cmd"
				;;
		esac
		;;
	$SZ_HA_NODE_ONLINE)
		log "[Node online]"
		local _host=`head -c 48 $1 | cut -b 9-48`
		log "node $_host online"
		#{
		#}&
		;;
	$SZ_PASSIVE_MAC)
		log "[Recive mac form remote node]"
		{
			$HA_PREFIX/sbin/synoha --fill-ha-mac-passive $1
		}&
		;;
	$SYNO_HA_MESG_REQ_AIS_HEADER)
		log "[mesg req]"
		{
			rm -f $SYNO_HA_DEBUG_DAT
			/usr/syno/bin/synomsg_collector $SYNO_HA_DEBUG_DAT
			$HA_PREFIX/etc.defaults/rc.ha send-debug-dat
			rm -f $SYNO_HA_DEBUG_DAT
		}&
		;;
	$SYNO_HA_MESG_RES_AIS_HEADER)
		log "[mesg res]"
		{
			touch $SYNO_HA_DEBUG_DAT_DONE
		}&
		;;
	*)
		log "unknown header: $header."
		return 1
		;;
esac
return 0
