#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.

SynoStop=/usr/bin/killall
RM=/bin/rm
STARTFTP="/var/tmp/startftp"
PROCNAME="ftpd"
PIDFILE="/var/run/$PROCNAME.pid"

. /etc.defaults/rc.subr

case $1 in
start)
	if ! [ -x /usr/syno/sbin/ftpd ]; then
		exit $LSB_ERR_INSTALLED
	fi
	if [ -f "$STARTFTP" ]; then
		exit 0;
	fi
	Run=`/bin/get_key_value /etc/synoinfo.conf runftpd`
	if [ "yes" = "$Run" ]; then
		
		echo "Starting ftpd ..."
		if [ "0" = "`ps | grep /usr/syno/sbin/ftpd | grep -vc grep`" ]; then
			/bin/sh /usr/syno/etc.defaults/rc.ftpd > /dev/null 2>&1 &
		else
			echo "ftpd already exists..."
		fi
	fi
	;;
stop)	
	$SynoStop ftpd > /dev/null 2>&1
	if [ -f $PIDFILE ]; then
		$RM $PIDFILE
	fi
	;;
restart)
	$0 stop
	$0 start
	;;
status)
	lsb_status $PROCNAME $PIDFILE
	;;
*)
	echo "Usages: $0 [start|stop|restart|status]"
	;;
esac

