#!/bin/sh
# Copyright (c) 2000-2009 Synology Inc. All rights reserved.

Httpd="/usr/syno/apache/bin/httpd"
HttpdConf="/usr/syno/apache/conf/httpd-webdav.conf-sys"
HttpdSSLConf="/usr/syno/apache/conf/extra/httpd-ssl-webdav.conf-sys"
HttpdSSLConfCommon="/usr/syno/apache/conf/extra/httpd-ssl.conf-common"
PIDFILE="/var/run/httpd-webdav.pid"
RunWEBDAV=`/bin/get_key_value /etc/synoinfo.conf runWebDav`
RunWEBDAVHTTPS=`/bin/get_key_value /etc/synoinfo.conf runWebDavHTTPS`
RunCALDAV=`/bin/get_key_value /etc/synoinfo.conf runCalDav`
SSLKEYGEN="/usr/syno/etc.defaults/rc.ssl_keygen"
CGIKEYGEN="/usr/syno/etc.defaults/rc.cgi_keygen"
INTERCRT="/usr/syno/etc/ssl/ssl.intercrt/server-ca.crt"

. /etc.defaults/rc.subr

GenerateConf()
{
	WEBDAV_PORT=`/bin/get_key_value /etc/synoinfo.conf WebDavPort`
	if [ -z "$WEBDAV_PORT" ]; then
		WEBDAV_PORT=`/bin/get_key_value /etc.defaults/synoinfo.conf WebDavPort`
		if [ -z "$WEBDAV_PORT" ]; then
			WEBDAV_PORT="5005"
		fi
	fi
	WEBDAV_SSL_PORT=`/bin/get_key_value /etc/synoinfo.conf secure_WebDavPort`
	if [ -z "$WEBDAV_SSL_PORT" ]; then
		WEBDAV_SSL_PORT=`/bin/get_key_value /etc.defaults/synoinfo.conf secure_WebDavPort`
		if [ -z "$WEBDAV_SSL_PORT" ]; then
			WEBDAV_SSL_PORT="5006"
		fi
	fi

	if [ -z "$RunWEBDAV" ]; then
		RunWEBDAV="no"
	fi
	if [ -z "$RunWEBDAVHTTPS" ]; then
		RunWEBDAVHTTPS="no"
	fi
	if [ -z "$RunCALDAV" ]; then
		RunCALDAV="no"
	fi

	DAV_LINE="Listen"
	if [ "no" =  "$RunWEBDAV" -a "yes" = "$RunWEBDAVHTTPS" ]; then
		DAV_AWK="/^L/,\"#L\""
	else
		DAV_AWK="/^#L/,\"L\""
	fi

	cp -f ${HttpdConf} ${HttpdConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t `basename $0` "backup ${HttpdConf} failed."
		rm -f ${HttpdConf}.$$
		return 1
	fi
	if [ "no" = "$RunWEBDAV" -a "yes" = "$RunWEBDAVHTTPS" ]; then
		sed -e "/^Listen/c\\Listen ${WEBDAV_SSL_PORT}" -e "/^ServerName/c\\ServerName *:${WEBDAV_SSL_PORT}" ${HttpdConf} > ${HttpdConf}.$$
	else
		sed -e "/^Listen/c\\Listen ${WEBDAV_PORT}" -e "/^ServerName/c\\ServerName *:${WEBDAV_PORT}" ${HttpdConf} > ${HttpdConf}.$$
	fi
	if [ -s "${HttpdConf}.$$" ]; then
		mv ${HttpdConf}.$$ ${HttpdConf}
	fi

	cp -f ${HttpdConf} ${HttpdConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t `basename $0` "backup ${HttpdConf} failed."
		rm -f ${HttpdConf}.$$
		return 1
	fi
	if [ "yes" = "$RunCALDAV" ]; then
		sed -e "/^#LoadModule dav_acl_module/c\\LoadModule dav_acl_module modules\/mod_davacl.so" -e "/^#LoadModule caldav_module/c\\LoadModule caldav_module modules/mod_caldav.so" ${HttpdConf} > ${HttpdConf}.$$
	else
		sed -e "/^LoadModule dav_acl_module/c\\#LoadModule dav_acl_module modules\/mod_davacl.so" -e "/^LoadModule caldav_module/c\\#LoadModule caldav_module modules/mod_caldav.so" ${HttpdConf} > ${HttpdConf}.$$
	fi
	if ! grep "LoadModule synobandwidth_module modules/mod_synobandwidth.so" ${HttpdConf}; then
		echo "LoadModule synobandwidth_module modules/mod_synobandwidth.so" >> ${HttpdConf}.$$
	fi
	if [ -s "${HttpdConf}.$$" ]; then
		mv ${HttpdConf}.$$ ${HttpdConf}
	fi

	cp -f ${HttpdSSLConf} ${HttpdSSLConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t `basename $0` "backup ${HttpdSSLConf} failed."
		rm -f ${HttpdSSLConf}.$$
		return 1
	fi

	sed -e "/^Listen/c\\Listen ${WEBDAV_SSL_PORT}" \
	    -e "/^<VirtualHost/c\\<VirtualHost *:${WEBDAV_SSL_PORT}>" \
	    ${HttpdSSLConf} | awk "{if(/${DAV_LINE}/)sub(${DAV_AWK});print}" > ${HttpdSSLConf}.$$

	if [ -s "${HttpdSSLConf}.$$" ]; then
		mv ${HttpdSSLConf}.$$ ${HttpdSSLConf}
	fi

	rm -f ${HttpdConf}.$$ ${HttpdSSLConf}.$$ 2>/dev/null

	if [ -s ${HttpdSSLConfCommon} ]; then
		if [ -f $INTERCRT ]; then
			sed -e "/^#SSLCertificateChainFile/c\\SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCommon} > ${HttpdSSLConfCommon}.$$
		else
			sed -e "/^SSLCertificateChainFile/c\\#SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCommon} > ${HttpdSSLConfCommon}.$$
		fi

		if [ -s "${HttpdSSLConfCommon}.$$" ]; then
			mv ${HttpdSSLConfCommon}.$$ ${HttpdSSLConfCommon}
		fi

		rm -f ${HttpdSSLConfCommon}.$$ 2>/dev/null
	fi
}

BIN_RELAYD="/usr/syno/sbin/synorelayd"
UpdateRelayd()
{
	local relayd_arg=

	/usr/syno/etc/rc.d/S13synorelayd.sh status
	if [ $? -ne $LSB_STAT_RUNNING ] ; then
	    return
	fi

	# if anyone is enabled
	if $BIN_RELAYD -S | grep -e '"webdav_http"' -e '"webdavs_https"' >/dev/null; then
		if [ "$RunWEBDAV" = "yes" ]; then
			relayd_arg="$relayd_arg --add webdav_http"
		fi
		if [ "$RunWEBDAVHTTPS" = "yes" ]; then
			relayd_arg="$relayd_arg --add webdavs_https"
		fi
	fi

	if [ "$RunWEBDAV" = "no" ]; then
		relayd_arg="$relayd_arg --remove webdav_http"
	fi
	if [ "$RunWEBDAVHTTPS" = "no" ]; then
		relayd_arg="$relayd_arg --remove webdavs_https"
	fi


	if [ -z "$relayd_arg" ]; then
		relayd_arg="--hup"
	fi

	$BIN_RELAYD $relayd_arg
	return 0
	# ignore relayd return value.
	# when relayd is not running, hup will return false
}

# check for pidfile
if [ -f $PIDFILE ] ; then
	PID=`cat $PIDFILE`
	if [ "x$PID" != "x" ] && kill -0 $PID 2>/dev/null ; then
		STATUS="httpd (pid $PID) running"
		RUNNING=1
	else
		STATUS="httpd (pid $PID?) not running"
		RUNNING=0
	fi
else
	STATUS="httpd (no pid file) not running"
	RUNNING=0
fi

case $1 in
[Ss][Tt][Oo][Pp])
	if [ $RUNNING -eq 0 ]; then
		echo $STATUS
	else
		if kill $PID ; then
			echo "$0: webdav httpd stopped"
		else
			echo "$0: webdav httpd could not be stopped"
			exit 1;
		fi
	fi

	UpdateRelayd
	;;
[Ss][Tt][Aa][Rr][Tt])
	$SSLKEYGEN > /dev/null 2>&1
	$CGIKEYGEN > /dev/null 2>&1 &
	if [ ! -x "$Httpd" ]; then
		echo "$Httpd is not executable."
		exit 1;
	fi

	if [ $RUNNING -eq 1 ]; then
		echo "$0 $ARG: httpd (pid $PID) already running"
	else
		GenerateConf

		if [ "yes" = "$RunWEBDAVHTTPS" -o "yes" = "$RunWEBDAV" ]; then
			startArg=""
			if [ "yes" = "$RunWEBDAVHTTPS" ]; then
				startArg="$startArg -DSSL"
			fi

			startArg="$startArg -f ${HttpdConf}"

			echo "Start WebDav Apache Server ..... $startArg"
			if $Httpd $startArg; then
				echo "$0: webdav httpd started"
			else
				echo "$0: webdav httpd could not be started"
				exit 1;
			fi
			UpdateRelayd
		fi
	fi
	;;
[Rr][Ee][Ss][Tt][Aa][Rr][Tt])
	if [ $RUNNING -eq 0 ]; then
		$0 start
	else
		$0 stop
		sleep 3
		$0 start
	fi
	;;
*)
	echo "Usage: $0 [start|stop|restart]"
	;;
esac
exit 0;
