#!/bin/sh
#
# S02dbus.sh - startup script for crond
#
# This goes in /usr/syno/etc/rc.d and gets run at boot-time.

DBUS=/usr/syno/sbin/dbus-daemon
DBUS_SESSION_ADDRESS_FILE=/tmp/.syno_dbus_session_address

case "$1" in

start)
	if [ -x "$DBUS" ] ; then
		echo "Starting dbus-daemon..."
		$DBUS --system --nopidfile
		ret=`$DBUS --session --fork --print-address`
		echo ${ret} > $DBUS_SESSION_ADDRESS_FILE
	fi
	;;

stop)
	echo "stop dbus"
	/usr/bin/killall dbus-daemon > /dev/null 2>&1
	;;

*)
	echo "usage: $0 { start | stop }" >&2
	exit 1
	;;

esac
