#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

HA_PREFIX="/usr/syno/synoha"
SERV_SCANUSBDEV="/etc.defaults/rc.scanusbdev"

. $HA_PREFIX/etc.defaults/rc.subr

case "$1" in
	start)
		synoha_log "SxxPost start"
		#/etc.defaults/scanusbdev should be called after start hotplug
		# <HA> #1268 - Add usb device again
		$SERV_SCANUSBDEV
		;;
	stop)
		synoha_log "SxxPost stop"
		# <HA Manager> #653 - call synovpnclient shutdown before stop
		# to prevent vpn reconnect on active, and allow vpn reconnect on passive
		ServiceScript=`find $SYNO_INITD_DIR -follow -name *synovpnclient*`
		hasScript=$?
		if [ "0" == $hasScript ]; then
			synoha_log " shutdown $ServiceScript..."
			$ServiceScript shutdown
		fi

		;;
	restart)
		stop
		start
		;;
	status)
		;;
	*)
		echo "Usages: $0 [start|stop|restart|status]"
		;;
esac
exit $?

