<?php

/* Get key value in $file and reture as a hash.
 * The $list is a array of keys that you would like
 * to get from file. If $list is not set, it will
 * get the whole file.
 */
function SYNOKeyValueFileToHash($file, $list = FALSE)
{
	$counter = 0;
	$listsize = 0;
	$hash = array();
	$pf = fopen($file, 'r');
	if (!$pf) {
		return $hash;
	}
	if ($list) {
		$listsize = sizeof($list);
	}
	while (!feof($pf)){
		$line = fgets($pf, 4096);
		$line = trim($line);
		if($line{0} == '#')
			continue;
		if($line{0} == '[')
			continue;
		list($key, $val) = explode("=", $line, 2);
		$key = trim($key);
		if ($list) {
			if (!in_array($key, $list)) {
				continue;
			}
		}
		$val = trim($val);
		if ($val{0} == '"') {
			$val = substr($val, 1, -1);
		}
		$hash[$key] = $val;
		$counter++;
		if ($listsize && $counter == $listsize) {
			break;
		}
	}

	fclose($pf);
	return $hash;
}

$SynoInfo = SYNOKeyValueFileToHash("/etc.defaults/synoinfo.conf", array("supplang", "vender", "updateurl", "ipv4only"));

/* Get client browser supported language and check our supported
 * language. If client language is not supported, we will return enu.
 */
function SYNOGetLanguage()
{
	global $SynoInfo;
	
	$szLang = "enu";

	$SuppLang = $SynoInfo["supplang"];
	$HttpStr = $_SERVER["HTTP_ACCEPT_LANGUAGE"];

	$HttpLang = strtok($HttpStr, ",;\n");
	
	while ($HttpLang) {
		if (!strcasecmp($HttpLang, "zh-tw") || 
			!strcasecmp($HttpLang, "zh-hk") ||
			!strcasecmp($HttpLang, "zh-mo")) {

			if (strstr($SuppLang, "cht")) {
				$szLang = "cht";
				break;
			}
		}
		else if (!strncasecmp($HttpLang, "zh", 2)) {
			if (strstr($SuppLang, "chs")) {
				$szLang = "chs";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "en") ||
				 !strncasecmp($HttpLang, "en-", 3)) {
			$szLang = "enu";
			break;
		}
		else if (!strcasecmp($HttpLang, "de") ||
				 !strncasecmp($HttpLang, "de-", 3)) {
			if (strstr($SuppLang, "ger")) {
				$szLang = "ger";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "ja") ||
				 !strncasecmp($HttpLang, "ja-", 3)) {
			if (strstr($SuppLang, "jpn")) {
				$szLang = "jpn";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "ko") ||
				 !strncasecmp($HttpLang, "ko-", 3)) {
			if (strstr($SuppLang, "krn")) {
				$szLang = "krn";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "es") ||
				 !strncasecmp($HttpLang, "es-", 3)) {
			if (strstr($SuppLang, "spn")) {
				$szLang = "spn";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "fr") ||
				 !strncasecmp($HttpLang, "fr-", 3)) {
			if (strstr($SuppLang, "fre")) {
				$szLang = "fre";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "it") ||
				 !strncasecmp($HttpLang, "it-", 3)) {
			if (strstr($SuppLang, "ita")) {
				$szLang = "ita";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "ru") ||
				 !strncasecmp($HttpLang, "ru-", 3)) {
			if (strstr($SuppLang, "rus")) {
				$szLang = "rus";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "da") ||
				 !strncasecmp($HttpLang, "da-", 3)) {
			if (strstr($SuppLang, "dan")) {
				$szLang = "dan";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "sv") ||
				 !strncasecmp($HttpLang, "sv-", 3)) {
			if (strstr($SuppLang, "sve")) {
				$szLang = "sve";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "nl") ||
				 !strncasecmp($HttpLang, "nl-", 3)) {
			if (strstr($SuppLang, "nld")) {
				$szLang = "nld";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "pl") ||
				 !strncasecmp($HttpLang, "pl-", 3)) {
			if (strstr($SuppLang, "plk")) {
				$szLang = "plk";
				break;
			}
		}
		else if (!strncasecmp($HttpLang, "pt-br", 5)) {
			if (strstr($SuppLang, "pt-br")) {
				$szLang = "ptb";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "pt") ||
				 !strncasecmp($HttpLang, "pt-", 3)) {
			if (strstr($SuppLang, "ptg")) {
				$szLang = "ptg";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "hu") ||
				 !strncasecmp($HttpLang, "hu-", 3)) {
			if (strstr($SuppLang, "hun")) {
				$szLang = "hun";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "tr") ||
				 !strncasecmp($HttpLang, "tr-", 3)) {
			if (strstr($SuppLang, "trk")) {
				$szLang = "trk";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "no") ||
				 !strncasecmp($HttpLang, "no-", 3) ||
				 !strcasecmp($HttpLang, "nb") ||
				 !strncasecmp($HttpLang, "nb-", 3) ||
				 !strcasecmp($HttpLang, "nn") ||
				 !strncasecmp($HttpLang, "nn-", 3)) {
			if (strstr($SuppLang, "nor")) {
				$szLang = "nor";
				break;
			}
		}
		else if (!strcasecmp($HttpLang, "cs") ||
				 !strncasecmp($HttpLang, "cs-", 3)) {
			if (strstr($SuppLang, "csy")) {
				$szLang = "csy";
				break;
			}
		}

		$HttpLang = strtok(",;\n");
	}

	return $szLang;
}

$SYNO_TEMPLATE_FILE = "webtemplate.html";
$ADMIN_PORT = "5000";

$ipv4only = $SynoInfo["ipv4only"];
$http_host = $_SERVER["HTTP_HOST"];
if(!strcasecmp($ipv4only, "yes")) {
	$ds_host = @strtok($http_host, ":");
}else {
	if(strstr($http_host,"]")) {
		$ds_host = @strtok($http_host, "]");
		$ds_host = $ds_host."]";
	}else {
		$ds_host = @strtok($http_host, ":");
	}
}
$admin_link = "http://".$ds_host.":".$ADMIN_PORT."/";
$error_page = "/var/services/web/missing";
$request_uri = $_SERVER["REQUEST_URI"];
$tmp = strtok($request_uri, "/");

function is_from_user_root()
{
	if (!isset($_GET['status'])) {
		return false;
	}
	if (!isset($_GET['from']) || ('user' !== $_GET['from'])) {
		return false;
	}
	if ('/' !== $_SERVER['REQUEST_URI']) {
		return false;
	}

	return true;
}

if (is_from_user_root()) {
	header("Location: ".$admin_link);
} else {
	if (strchr($tmp,"~")) {
		$localuser = strtok($tmp,"~");
		$error_page = "/var/services/homes/".$localuser."/www/missing";
	} else {
		$error_page = $_SERVER['DOCUMENT_ROOT']."/missing";
	}

	if ( @stat($error_page.".html") != NULL ) {
		include($error_page.".html");
	} else if ( @stat($error_page.".htm") != NULL ) {
		include($error_page.".htm");
	} else if ( @stat($error_page.".php") != NULL ) {
		include($error_page.".php");
	} else {

		$SYNO_TEXT_DIR = "/usr/syno/synoman/webman/texts";

		//get client language
		$Lang = SYNOGetLanguage();
		$Strings = SYNOKeyValueFileToHash($SYNO_TEXT_DIR."/".$Lang."/strings", array("error_page", "error_page_desc", "back"));

		// Parse the template.html file
		$template_file = $SYNO_TEMPLATE_FILE;
		$template = fread(fopen($template_file, 'r'), filesize($template_file));

		$template = str_replace('{TITLE}', $Strings["error_page"], $template);
		$template = str_replace('{MESSAGE}', $Strings["error_page_desc"] ,$template);
		$template = str_replace('{BACK}', $Strings["back"] ,$template);
		$template = str_replace('{VENDER}', $SynoInfo["vender"], $template);
		$template = str_replace('{VENDERURL}', $SynoInfo["updateurl"], $template);

		echo $template;
	}
}

?>
