<?php
/* Copyright (c) 2013 Synology Inc. All rights reserved. */
defined('FETCH_KEY_CMD') or define('FETCH_KEY_CMD', '/bin/get_key_value');
defined('SYNO_INFO_CONF_DEF') or
	define('SYNO_INFO_CONF_DEF', '/etc.defaults/synoinfo.conf');
defined('DSM_VERSION') or define('DSM_VERSION', '/etc.defaults/VERSION');
defined('INFO_KEY_UNIQUE') or define('INFO_KEY_UNIQUE', 'unique');
defined('VERSION_KEYS') or define('VERSION_KEYS', serialize(array(
	'majorversion',
    'minorversion',
	'buildnumber'
)));

function getUnique()
{
    $cmd = FETCH_KEY_CMD . ' ' . SYNO_INFO_CONF_DEF . ' ' . INFO_KEY_UNIQUE;
    $unique = trim(system($cmd, $ret));
    return $unique;
}

function getVersion()
{
    $version = array();
    
    foreach (unserialize(VERSION_KEYS) as $key) {
        $cmd = FETCH_KEY_CMD . ' ' . DSM_VERSION . ' ' . $key;
        $result = trim(system($cmd, $ret));
        $version[$key] = $result;
    }

    return $version;
}

function getUserAgent()
{
	$unique = getUnique();
	$version = getVersion();
	return sprintf('%s DSM%s.%s %s (autoupgrade)',
		$unique,
		$version['majorversion'],
		$version['minorversion'],
		$version['buildnumber']
	);
}
