/*var synoShareListData = [
	[ 'public', 1024 ],
	[ 'music',  2048 ],
	[ 'video',  4096 ]
];*/
//var synoShareListShareNum = 3;
var ShareListColorHash = {};

function getTotalShareSize()
{
	var i, sum=0;
	for (i=0; i<synoShareListData.length; i++) {
		sum += parseInt(synoShareListData[i][2], 10);
	}
	return sum;
}

function shareListTranslateData(tableData, pieData, myColor)
{
    var i, key, total=0;
    var HashTmp = {};
	ShareListColorHash = {};

    i=0;
	for(i=0; i< tableData.length; i++) {
		if(i > 8) {
			ShareListColorHash[tableData[i][0]] = ShareListColorHash[tableData[8][0]];
		} else {
			pickColor(ShareListColorHash, tableData[i][0], i, tableData.length);
		}
		pieData.push( { data: [[ 0, parseInt(tableData[i][2],10) ]], label : tableData[i][0] } );
		myColor.push(ShareListColorHash[tableData[i][0]]);
    }
}


function shareListPie(container, tableData)
{
  var pieData = [];

  var graph, myColor = [], key;

  shareListTranslateData(tableData, pieData, myColor);


  graph = Flotr.draw(container.dom, pieData, {
    HtmlText : false,
    grid : {
      outlineWidth: 0,
      labelMargin: 0,
      verticalLines : false,
      horizontalLines : false
    },
    xaxis : { showLabels : false },
    yaxis : { showLabels : false },
    pie : {
	sizeRatio: 0.95,
      show : true,
      fill: true,
      startAngle: 0.5,
      explode: 0,
      labelFormatter: function() {return '';}
    },
    colors: myColor,
    mouse: {
        track : true,
        lineColor : '#FFFFFF',
        trackFormatter: function(x) {
			return x.series.label;
        }
    },
    shadowSize: 0,
    legend : { show : false }
  });
}



function showShareList()
{
    Ext.QuickTips.init();

	if(typeof synoShareListData === "undefined" || synoShareListData.length === 0) {
		NoDataSet('share_list_nodata');
		return ;
	}

	/*var html = '<table width="930px"><tr height="30px">\n';
	var shareListBar = Ext.fly('share_list_bar');
	var i, percent;
	var color;
	var totalShareSize = getTotalShareSize();
	for (i=0; i<synoShareListData.length; i++) {
		percent = parseInt(100 * synoShareListData[i][2]/totalShareSize, 10);
		color = pickColor(ShareListColorHash, synoShareListData[i][0], i, synoShareListData.length);
		html += '<td ext:qtip="' + synoShareListData[i][0] + '" width="' + percent + '%" bgcolor="' + color + '">&nbsp;</td>';
	}
	html += '</tr></table>';
	shareListBar.update(html);
	*/

	shareListPie(Ext.fly('share_list_pie'), synoShareListData);
	shareListTable();
}

function ShareColor(val)
{
	return "<table><tr><td width=12 height=10 bgcolor='" + ShareListColorHash[val] +
		"'>&nbsp;</td><td>&nbsp;" + val + "</td></tr></table>";
}

/*!
 * Ext JS Library 3.4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
function shareListTable()
{

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Share'},
           {name: 'Volume'},
           {name: 'Size'}
        ]
    });

    // manually load local data
    store.loadData(synoShareListData);

    // create the Grid
    var grid = new Ext.grid.GridPanel({
		border: false,
        store: store,
		stripeRows: true,
        width: 670,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		viewConfig: GridViewConfig,
        columns: [
            {
                id       : 'Share',
				header   : styleHeaderRenderer(_T('report', 'reportUI_title_share')),
                width    : 270,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_share'),
                renderer : styleRendererDecorator(ShareColor),
                dataIndex: 'Share',
				align: 'left'
            }, {
                id       : 'Volume',
				header   : _T('report', 'reportUI_title_volume'),
                width    : 200,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_volume'),
                renderer : VolumeId2Name,
                dataIndex: 'Volume',
				align: 'center'
            }, {
				header   : _T('common','size'),
                sortable : true,
                width    : 200,
				tooltip  : _T('common','size'),
                renderer : SizeUnit,
                dataIndex: 'Size'
            }
        ],
        plugins: [ new GridPanelPlugin(14) ]
    });

    // render the grid to the specified div in the page
    grid.render('share-list');
}
