#!/bin/sh
#
# S66S2S.sh - startup script for S2S daemons
#
# This goes in /usr/syno/etc/rc.d and gets run at boot-time.

S2SMonitord=s2s_monitor
S2SSyncd=s2s_syncd
S2SSyncer=s2s_syncer
S2SCreateTaskFakeFile=s2s_createTaskFakeFile
MaxWatches=8192
MaxQueueEvents=163840

#retrive MaxWatches from synoinfo.conf
SupportS2S=`/bin/get_key_value /etc.defaults/synoinfo.conf support_s2s`
if [ "yes" = "${SupportS2S}" -o "YES" = "${SupportS2S}"  ]; then
    MaxWatches=`/bin/get_key_value /etc.defaults/synoinfo.conf s2s_watches_max`
else
    exit 1
fi


case "$1" in

# daemon will check if task exist before start
start)
	if [ -x /usr/syno/bin/$S2SMonitord ] && [ -x /usr/syno/bin/$S2SSyncd ] && [ -x /usr/syno/bin/$S2SCreateTaskFakeFile ]; then
		echo "start S2S daemons ..."
		echo $MaxWatches > /proc/sys/fs/inotify/max_user_watches
		echo $MaxQueueEvents > /proc/sys/fs/inotify/max_queued_events
		/usr/syno/bin/$S2SMonitord -rdmx
		/usr/syno/bin/$S2SSyncd -rdmx
                /usr/syno/bin/$S2SCreateTaskFakeFile
	fi
	;;

# daemon will NOT check if task exist before start
start_no_check) 
	if [ -x /usr/syno/bin/$S2SMonitord ] && [ -x /usr/syno/bin/$S2SSyncd ] && [ -x /usr/syno/bin/$S2SCreateTaskFakeFile ]; then
		echo "start S2S daemons without checking the existence of task ..."
		echo $MaxWatches > /proc/sys/fs/inotify/max_user_watches
		echo $MaxQueueEvents > /proc/sys/fs/inotify/max_queued_events
		/usr/syno/bin/$S2SMonitord -rdm
		/usr/syno/bin/$S2SSyncd -rdm
                /usr/syno/bin/$S2SCreateTaskFakeFile
	fi
	;;

stop)
		echo "Stop S2S daemons ..."
		killall $S2SMonitord > /dev/null 2>&1
		killall $S2SSyncer > /dev/null 2>&1
		killall $S2SSyncd > /dev/null 2>&1
		;;
restart)
		$0 stop
		sleep 1
		$0 start
		;;
*)
		echo "Usage: $0 start|stop|restart|start_no_check"
	;;
esac
