BEGIN;

CREATE TABLE file_info(
 name TEXT NOT NULL,
 is_dir NUMERIC NOT NULL,
 path TEXT NOT NULL,
 file_ext TEXT,
 size NUMERIC NOT NULL,
 time_create NUMERIC NOT NULL,
 time_access NUMERIC NOT NULL,
 time_modify NUMERIC NOT NULL,
 privilege TEXT NOT NULL,
 owner_name TEXT NOT NULL,
 group_name TEXT NOT NULL,
 PRIMARY KEY (path)
);

CREATE INDEX file_info_name_idx ON file_info (name);
CREATE INDEX file_info_is_dir_idx ON file_info (is_dir);
CREATE INDEX file_info_path_idx ON file_info (path);
CREATE INDEX file_info_file_ext_idx ON file_info (file_ext);
CREATE INDEX file_info_size_idx ON file_info (size);
CREATE INDEX file_info_ctime_idx ON file_info (time_create);
CREATE INDEX file_info_atime_idx ON file_info (time_access);
CREATE INDEX file_info_mtime_idx ON file_info (time_modify);
CREATE INDEX file_info_owner_name_idx ON file_info (owner_name);
CREATE INDEX file_info_group_name_idx ON file_info (group_name);

COMMIT;

