#!/bin/sh
# Copyright (c) 2000-2005 Synology Inc. All rights reserved.
KERNEL_VERSION=`uname -r`

CheckProcDead() {
	killall $1 > /dev/null 2>&1

	count=5
	while [ $count -gt 0 ]; do
		pidof $1 > /dev/null 2>&1
		if [ $? -ne 0 ]; then
			return 0
		fi
		sleep 1
		killall $1 > /dev/null 2>&1
		count=`expr $count - 1`
	done
}

SYNOMKTHUMBD="/usr/syno/bin/synomkthumbd"

case $1 in
	start)
		echo "Starting Synology Make Thumb Daemon..."
		case "$KERNEL_VERSION" in
		"2.4.22-uc0" | "2.6.15" | "2.6.24")
			sleep 180 && $SYNOMKTHUMBD &
			;;
		*)
			$SYNOMKTHUMBD
			;;
		esac
	;;
	stop)
		echo "Stopping Synology Make Thumb Daemon..."

		#To ensure that thumb is dead before volume removed
		CheckProcDead synomkthumbd
		CheckProcDead synothumb
		CheckProcDead convert
		CheckProcDead dcraw
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
	;;
esac

