#!/bin/sh

###############################################################
#   This script should be hooked when invoking synocheckshare
#   Usable environment variable:
#		NITEMS, SHARE_NAME_X, SHARE_PATH_X,
#		SHARE_STATUS_OLD_X, SHARE_STATUS_X
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
FILE_SYNOINDEX_INC_SCRP=/usr/libexec/SynoindexShareCommon.sh
. ${FILE_SYNOINDEX_INC_SCRP}

CheckShareEncrypt() {
	if [ "encrypt" != "${ORIGIN_SHARE_STATUS}" -a "encrypt" = "${SHARE_STATUS}" ]; then
		DO_INDEX_DEL=1
	elif [ "encrypt" = "${ORIGIN_SHARE_STATUS}" -a "decrypt" = "${SHARE_STATUS}" ]; then
		DO_INDEX_REINDEX=1
	elif [ "decrypt" = "${ORIGIN_SHARE_STATUS}" -a "normal" = "${SHARE_STATUS}" ]; then
		DO_INDEX_REINDEX=1
	fi
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo ${SYNOINDEX_PKG_MODVER}
	;;
	--name)
	#Print package name
	echo ${SYNOINDEX_PKG_NAME}
	;;
	--pkg-ver)
	#Print package version
	echo ${SYNOINDEX_PKG_VERSION}
	;;
	--vendor)
	#Print package vendor
	echo ${SYNOINDEX_PKG_VENDOR}
	;;
	--pre)
	#Actions before synocheckshare
	;;
	--post)
	INDEX=1;
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
		eval "SHARE_PATH=\$SHARE_PATH_$INDEX"
		eval "ORIGIN_SHARE_STATUS=\$SHARE_STATUS_OLD_$INDEX"
		eval "SHARE_STATUS=\$SHARE_STATUS_$INDEX"

		DO_INDEX_DEL=0
		DO_INDEX_REINDEX=0
		SYNOINDEX_SHARE_PATH=$SHARE_PATH

		CheckShareEncrypt

		if [ "1" = "${DO_INDEX_DEL}" ]; then
			SynoindexRemove
		elif [ "1" = "${DO_INDEX_REINDEX}" ]; then
			SynoindexReindex
		fi

		INDEX=$((INDEX + 1))
	done
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

