#!/bin/sh
#set -x
pidfiledir=/var/run
NSLCD=/usr/syno/sbin/nslcd
KILLALL=/usr/bin/killall
KILL=/bin/kill
PIDOF=/bin/pidof
RM=/bin/rm
ECHO=/bin/echo
MV=/bin/mv
CAT=/bin/cat
SLEEP=/bin/sleep
LS=/bin/ls
AWK=/usr/bin/awk
DF=/bin/df
GREP=/bin/grep
TOUCH=/bin/touch
LN=/bin/ln
HEAD=/usr/bin/head
RunNSLCD=`/bin/get_key_value /etc/synoinfo.conf ldapbinded`	

WaitProcDead() {
	i=0
	while [ $i -lt 3 ] ; do
		$PIDOF $1 > /dev/null 2>&1
		Ret=$?
		if [ $Ret -eq 1 ] ; then
			break;
		fi
		$SLEEP 1
		i=`expr $i + 1`
	done
}


CheckPidExist()
{
	if [ -f "$1" ]; then
		Pid=`$CAT "$1"`
		if [ "$Pid" -ne "" -a -d "/proc/$Pid" ]; then
			return 1
		fi
	fi
	return 0
}



# start
if [ "x$1" = "x" -o "x$1" = "xstart" ]; then
	if [ "$RunNSLCD" == "yes" ]; then

		CheckPidExist $pidfiledir/nslcd.pid
		Ret=$?
		if [ -x $NSLCD -a $Ret -eq 0 ]; then
			$ECHO "#################"
			$ECHO ' Starting Nslcd'
			$ECHO "#################"
			$NSLCD &
		fi
	fi
# stop
elif [ "x$1" = "xstop" ]; then
	$ECHO
	$ECHO "#################"
	$ECHO ' Stoping Nslcd'
	$ECHO "#################"
	$KILL `$CAT $pidfiledir/nslcd.pid 2>/dev/null` > /dev/null 2>&1
	WaitProcDead "nslcd"
	$KILLALL nslcd > /dev/null 2>&1
elif [ "x$1" = "xrestart" ]; then
	$0 stop
	$0 start
fi
