#!/bin/sh
#chkconfig: 2345 20 80
#description: #start/stop opentftp
#Originally Contributed by sharne, slightly modified.

##### Modify 3 line below for location of executive and other files #####
EXEFILE=/usr/syno/sbin/opentftp
INIFILE=/etc/opentftp.ini
LOGFILE=/var/log/opentftp.log
##### There is generally no need to modify anything below this line #####
PIDFILE="/tmp/opentftp.pid"
# Get pid
is_daemon_alive() {
	if [ -f "$1" ]; then
		local pid=`cat "$1"`

		kill -0 $pid
		if [ "0" = "$?" ]; then
			echo "$pid";
			return 1;
		else
			echo "0";
			return 0;
		fi
	fi

	echo "0";
	return 0;
}

getpid() {
	pidnum=`is_daemon_alive $PIDFILE`
}

# Start opentftp:
opentftp_start() {
	Run=`/bin/get_key_value /etc/synoinfo.conf runtftp`
	if [ "yes" = "$Run" ]; then
		${EXEFILE} -i ${INIFILE} -l ${LOGFILE}
		while [ "0" == `is_daemon_alive "$PIDFILE"` ];
		do
			sleep 1;
		done
		echo "Open TFTP Server started"
	fi
}

# Stop opentftp:
opentftp_stop() {
	retry=30

	kill $pidnum

	while [ $retry -gt 0 ] && [ "0" != `is_daemon_alive "$PIDFILE"` ];
	do
		sleep 1;
		retry=`expr $retry - 1`
	done

	if [ "0" != `is_daemon_alive "$PIDFILE"` ] ; then
		kill -9 $pidnum
		echo "TFTP Server still running, force kill"
	fi

	echo "Open TFTP Server stopped"
	if [ -e "$PIDFILE" ] ; then
		rm "$PIDFILE"
	fi
}

case "$1" in
'start')
	getpid
	if [ "0" == "$pidnum" ] ; then
		opentftp_start
		RETVAL=0
	else
		echo "Open TFTP Server is already running - Try restart"
		RETVAL=1
	fi
	;;
'stop')
	getpid
	if [ "0" == "$pidnum" ] ; then
		echo "Open TFTP Server is not running"
		RETVAL=1
	else
		opentftp_stop
		RETVAL=0
	fi
	;;
'restart')
	getpid
	if [ "0" == "$pidnum" ] ; then
		echo "Open TFTP Server is not running"
		opentftp_start
	else
		opentftp_stop
		opentftp_start
	fi
	RETVAL=0
	;;
'status')
	getpid
	if [ "0" == "$pidnum" ] ; then
		echo "Open TFTP Server is stopped"
		RETVAL=1
	else
		echo "Open TFTP Server is running - Pid : $pidnum"
		RETVAL=0
	fi
	;;
*)
echo "Usage $0 { start | stop | restart | status }"
RETVAL=1
;;
esac
exit $RETVAL

# Enjoy!

