#!/bin/sh
#set -x
VERSION=2
pidfiledir=/var/run
conffile=/usr/syno/etc/openldap/slapd.conf
SLAPD=/usr/syno/sbin/slapd
KILLALL=/usr/bin/killall
KILL=/bin/kill
PIDOF=/bin/pidof
RM=/bin/rm
ECHO=/bin/echo
MV=/bin/mv
CAT=/bin/cat
SLEEP=/bin/sleep
LS=/bin/ls
AWK=/usr/bin/awk
DF=/bin/df
GREP=/bin/grep
TOUCH=/bin/touch
LN=/bin/ln
HEAD=/usr/bin/head
LOGGER=/usr/bin/logger
DB_RECOVER=/var/packages/DirectoryServer/target/bin/db_recover
SERVERCRT=/usr/syno/etc/ssl/ssl.crt/server.crt
SERVERKEY=/usr/syno/etc/ssl/ssl.key/server.key

RunSLAPD="no"
if stat /var/packages/DirectoryServer/enabled >/dev/null 2>&1; then
	RunSLAPD=`/bin/get_key_value /etc/synoinfo.conf runslapd`
fi

WaitProcDead() {
	local i=0
	while [ $i -lt 10 ] ; do
		if ! $PIDOF $1 > /dev/null 2>&1; then
			return 0
		fi
		$SLEEP 1
		i=`expr $i + 1`
	done
	return 1
}

WaitProcActive() {
	local i=0
	while [ $i -lt 5 ] ; do
		if [ `$PIDOF $1 | wc -w` -gt 1 ]; then
			return 0
		fi
		$SLEEP 1
		i=`expr $i + 1`
	done
	return 1
}

CheckPidExist()
{
	if [ -f "$1" ]; then
		Pid=`$CAT "$1"`
		if [ -n "$Pid" -a -d "/proc/$Pid" ]; then
			return 0
		fi
	fi
	return 1
}



case "$1" in
	start|'')
		if [ "$RunSLAPD" == "yes" ]; then

			if ! CheckPidExist $pidfiledir/slapd.pid && [ -x $SLAPD ]; then
				$ECHO "#################"
				$ECHO ' Starting Slapd'
				$ECHO "#################"
				if [ ! -s "$SERVERCRT" -o ! -s "$SERVERKEY" ]; then
					$LOGGER -p user.err -t `basename $0` "Empty certificates. Try to re-create."
					/usr/syno/etc/rc.ssl_keygen > /dev/null 2>&1
				fi
				$SLAPD -f $conffile -h "ldap:/// ldaps:///"
				if ! WaitProcActive "slapd" && ! CheckPidExist $pidfiledir/slapd.pid; then
					$KILLALL -9 slapd > /dev/null 2>&1
					if [ -x $DB_RECOVER ] && ! pidof slapd > /dev/null 2>&1 ; then
						$LOGGER -p user.err -t `basename $0` "start slapd failed. try to db_recover."
						$DB_RECOVER -h /usr/syno/etc/openldap/data/
						$SLAPD -f $conffile -h "ldap:/// ldaps:///"
					else
						$LOGGER -p user.err -t `basename $0` "db_recover not exists or slapd unexpected exists."
					fi
				fi
			fi
		fi
		;;
	stop)
		[ -e "/tmp/upgrade_stop_service" ] && exit 0
		$ECHO
		$ECHO "#################"
		$ECHO ' Stoping Slapd'
		$ECHO "#################"
		$KILL `$CAT $pidfiledir/slapd.pid 2>/dev/null` > /dev/null 2>&1
		if ! WaitProcDead "slapd"; then
			$LOGGER -p user.err -t `basename $0` "stop slapd by pidfile failed. using killall."
		fi
		$KILLALL slapd > /dev/null 2>&1
		if  ! WaitProcDead "slapd"; then
			$LOGGER -p user.err -t `basename $0` "stop slapd failed. using kill -9."
			$KILLALL -9 slapd > /dev/null 2>&1
		fi
		;;
	restart)
		$0 stop
		$0 start
		;;
esac
