#!/bin/sh
# Copyright (c) 2000-2010 Synology Inc. All rights reserved.

# Synology Service which need MDNS
# iTunes(mt-daapd), AFP, TimeMachine, HTTP:5000, Webdav
# Surveillance, PhotoStation, Printer
#
# FIXME: Let each service write down its own mdns service file.
# Should not generate them here

AVAHI_CONF_PATH="/usr/syno/avahi"
AVAHI_SERVICE_PATH="${AVAHI_CONF_PATH}/services"
SYNO_PRINT="/usr/syno/bin/synoprint"
PRINTER_CONF="/usr/syno/etc/printer.conf"
LOGGER="/usr/bin/logger"

log_msg()
{
	$LOGGER -sp $1 -t AVAHI "$2"
}

LoadServerID() {
	findIP=0
	IPaddr=''
	maxLanCount=`/bin/get_key_value /etc.defaults/synoinfo.conf maxlanport`
	if [ "$maxLanCount" = "" ]; then
		maxLanCount=1
	fi

	i=0
	while [ $i -le $maxLanCount ]; do
		ifconfig eth$i | grep inet
		if [ $? -eq 0 ];then #find IP
			IPaddr=`ifconfig eth$i | grep inet | cut -d':' -f2 | cut -d' ' -f1`
			findIP=1
			break;
		fi
		i=`expr $i + 1`
	done

	if [ $findIP -eq 1 ];then
    	    num=0;
	    # Transfer IP to number, e.g. 192.168.1.110 --> 2168001110
	    num1=`echo $IPaddr | cut -d'.' -f1`
	    num1=$((num1%10))
	    num2=`echo $IPaddr | cut -d'.' -f2`
	    num3=`echo $IPaddr | cut -d'.' -f3`
	    num4=`echo $IPaddr | cut -d'.' -f4`

	    num=$((num2 * 1000000 + num3 * 1000 + num4))
	    gITunesEncName=`printf "%d%d" $num1 $num`

	else
	    gITunesEncName=`date +%s`
	fi
}

GetAdminPort() {
    Port=`/bin/get_key_value /etc/synoinfo.conf admin_port`
	if [ "$Port" != "" ]; then
            echo $Port
        else
            echo 5000
        fi
}

AddTimeMachine() {
	PortTM=9
	Port=548
	TM_SCONF="$AVAHI_SERVICE_PATH/tm.service"

	share=`/bin/get_key_value /etc/synoinfo.conf time_machine_share`
	if [ "$share" = "" ]; then
		return
	fi
	MAC_addr=`/usr/syno/bin/netcardtool eth0`
	if [ $? -gt 0 ]; then
		return
	fi
	echo -en \
"<service-group>
<name>$1</name>
<service>
<type>_adisk._tcp</type>
<port>$PortTM</port>
<txt-record>sys=waMa=$MAC_addr,adVF=0x100</txt-record>
<txt-record>dk0=adVF=0x83,adVN=$share,adVU=5ae47c12-2331-4cba-9964-cl1234567890</txt-record>
</service>
</service-group>
" > $TM_SCONF
}

AddAFP() {
	Port=548
	AFP_SCONF="$AVAHI_SERVICE_PATH/afp.service"

	echo -en \
"<service-group>
<name>$1</name>
<service>
<type>_device-info._tcp</type>
<txt-record>model=Xserve</txt-record>
</service>
<service>
<type>_afpovertcp._tcp</type>
<port>$Port</port>
</service>
</service-group>
" > $AFP_SCONF
}


AddHTTP() {
	Port=`GetAdminPort`

	# Model name
	Model=`/bin/get_key_value /etc/synoinfo.conf upnpmodelname`

	# Serial number
	SupportMtdSerial=`/bin/get_key_value /etc.defaults/synoinfo.conf support_mtd_serial`
	if [ $SupportMtdSerial = "yes" ]; then
		Serial=`/bin/cat /proc/sys/kernel/syno_serial`
	else
		Serial="No Support mtd Serial"
	fi

	# DSM version
	MajorVersion=`/bin/get_key_value /etc.defaults/VERSION majorversion`
	MinorVersion=`/bin/get_key_value /etc.defaults/VERSION minorversion`
	BuildNumber=`/bin/get_key_value /etc.defaults/VERSION buildnumber`

	# http & https port number
	AdminPort=`/bin/get_key_value /etc/synoinfo.conf admin_port`
	SecureAdminPort=`/bin/get_key_value /etc/synoinfo.conf secure_admin_port`

	# Mac addresses
	maxLanCount=`/bin/get_key_value /etc.defaults/synoinfo.conf maxlanport`
	if [ "$maxLanCount" = "" ]; then
		maxLanCount=1
	fi

	i=0
	while [ $i -lt $maxLanCount ]; do
		MACaddr=`/usr/syno/bin/netcardtool eth$i`
		if [ $i -eq 0 ]; then
			AllMACaddrs="$MACaddr"
		else
			AllMACaddrs="$AllMACaddrs|$MACaddr"
		fi
		i=`expr $i + 1`
	done

	HTTP_SCONF="$AVAHI_SERVICE_PATH/http.service"

	echo -en \
"<service-group>
<name>$1</name>
<service>
<type>_http._tcp</type>
<port>$Port</port>
<txt-record>vendor=Synology</txt-record>
<txt-record>model=$Model</txt-record>
<txt-record>serial=$Serial</txt-record>
<txt-record>version_major=$MajorVersion</txt-record>
<txt-record>version_minor=$MinorVersion</txt-record>
<txt-record>version_build=$BuildNumber</txt-record>
<txt-record>admin_port=$AdminPort</txt-record>
<txt-record>secure_admin_port=$SecureAdminPort</txt-record>
<txt-record>mac_address=$AllMACaddrs</txt-record>
</service>
</service-group>
" > $HTTP_SCONF
}

AddWebdavHttp(){
   	Port=`/bin/get_key_value /etc/synoinfo.conf WebDavPort`
	WEBDAV_SCONF="$AVAHI_SERVICE_PATH/webdav.service"

	echo -en \
"<service-group>
<name>$1$2</name>
<service>
<type>_http._tcp</type>
<port>$Port</port>
</service>
</service-group>
" > $WEBDAV_SCONF
}

AddBoujourPrinter() {
	# check usbprinter1/usbprinter2
	# call AddBonjourPrinterConf to add to conf
	MFG_TOKENS="MFG: MANUFACTURER:"
	MDL_TOKENS="MDL: MODEL:"
	MAXPRINTER=`/bin/get_key_value /etc.defaults/synoinfo.conf maxprinters`
	PRINTER_PREFIX="usbprinter"

	for PrinterId in `$SYNO_PRINT --list`; do
		MFG=""; MDL="";
			PrinterStringId=`$SYNO_PRINT --getid $PrinterId`
			for tok in $MFG_TOKENS; do
				if echo $PrinterStringId | grep "$tok">/dev/null; then
					MFG=`echo $PrinterStringId | sed "s/.*$tok\([^;]*\);.*/\1/"`
					break
				fi
			done
			for tok in $MDL_TOKENS; do
				if echo $PrinterStringId | grep "$tok">/dev/null; then
					MDL=`echo $PrinterStringId | sed "s/.*$tok\([^;]*\);.*/\1/"`
					break
				fi
			done

			if [ "${MFG}${MDL}" != "" ]; then
				PrinterName=`$SYNO_PRINT --getname $PrinterId`
				AddBonjourPrinterConf $1 "$PrinterName" "$MFG $MDL" "$PrinterId"
			else
				echo "Fail to get model info of $PRINTER_PREFIX$i"
			fi
	done
}

AddBonjourPrinterConf() {
	PortLPR=515
	PortIPP=631
	PRINTER_SCONF="$AVAHI_SERVICE_PATH/$2.service"

	AIRPRINT_EXT=""
	AIRPRINT_SUBTYPE=""
	AIRPRINT_URF=""
	AIRPRINT_STAT=`/usr/syno/bin/synoprint --ckairprint $4`
	if [ "$AIRPRINT_STAT" = "on" ]; then
		AIRPRINT_EXT=",application/pdf,image/urf"
		AIRPRINT_URF="\n<txt-record>URF=W8,SRGB24,DM1,CP255,RS600-300</txt-record>"
		AIRPRINT_SUBTYPE="\n<subtype>_universal._sub._ipp._tcp</subtype>"
	fi

	POSTSCRIPT_EXT=""
	PrinterStringId=`$SYNO_PRINT --getid $PrinterId`
	echo $PrinterStringId |grep -i 'postscript' >/dev/null 2>&1
	if [ $? -eq 0 ];then
	    POSTSCRIPT_EXT=",application/postscript"
	fi

	echo -en \
"<service-group>
<name>$2 @ $1</name>
<service>
<type>_printer._tcp</type>
<port>$PortLPR</port>
<txt-record>txtvers=1</txt-record>
<txt-record>qtotal=2</txt-record>
<txt-record>ty=$3</txt-record>
<txt-record>note=$1($3)</txt-record>
<txt-record>pdl=application/octet-stream$POSTSCRIPT_EXT</txt-record>
<txt-record>rp=$2</txt-record>
</service>
<service>
<type>_ipp._tcp</type>$AIRPRINT_SUBTYPE
<port>$PortIPP</port>
<txt-record>txtvers=1</txt-record>
<txt-record>qtotal=2</txt-record>
<txt-record>ty=$3</txt-record>
<txt-record>note=$1($3)</txt-record>
<txt-record>product=($3)</txt-record>
<txt-record>pdl=application/octet-stream$AIRPRINT_EXT$POSTSCRIPT_EXT</txt-record>$AIRPRINT_URF
<txt-record>rp=printers/$2</txt-record>
</service>
</service-group>
" > $PRINTER_SCONF
}

CheckServices() {
	ServName=`/bin/get_key_value /etc/sysconfig/network HOSTNAME`

	if ! [ -d $AVAHI_SERVICE_PATH ]; then
		mkdir -p $AVAHI_SERVICE_PATH;
	else
		if [ -f ${AVAHI_SERVICE_PATH}/3rdparty.*.service ]; then
			mv ${AVAHI_SERVICE_PATH}/3rdparty.*.service ${AVAHI_CONF_PATH}
		fi
		rm ${AVAHI_SERVICE_PATH}/*.service
		if [ -f ${AVAHI_CONF_PATH}/3rdparty.*.service ]; then
			mv ${AVAHI_CONF_PATH}/3rdparty.*.service ${AVAHI_SERVICE_PATH}
		fi
	fi

	isAFPEnable=`/bin/get_key_value /etc/synoinfo.conf runafp`
	if [ "yes" = "$isAFPEnable" ]; then
		AddAFP $ServName
		AddTimeMachine $ServName
	fi

	isWebDAVHttpEnable=`/bin/get_key_value /etc/synoinfo.conf runWebDav`

	if [ "yes" = "$isWebDAVHttpEnable" ]; then
		WebDAVNAME="${ServName} (WebDAV)"
		AddWebdavHttp $WebDAVNAME
	fi

	isBoujourServiceEnable=`/bin/get_key_value /etc/synoinfo.conf run_bonjour_printer_service`

	if [ "yes" = "$isBoujourServiceEnable" ]; then
		AddBoujourPrinter $ServName
	fi

	AddHTTP $ServName
}





DESC="Avahi mDNS/DNS-SD Daemon"
NAME="avahi-daemon"
DAEMON="/usr/syno/sbin/$NAME"

case "$1" in
    start | reload)
		CheckServices
		if pidof $NAME; then
			echo "Reloading $DESC"
			$DAEMON -r
		else
			echo "Starting $DESC"
			$DAEMON -D
		fi
        ;;
    stop)
        echo "Stopping $DESC"
        if ! $DAEMON -k; then
			kill -9 `pidof $NAME`
		fi
        ;;
    restart)
        $0 stop
        $0 start
        ;;
    *)
        echo "usage: $0 {start|stop|restart|reload}"
	;;
esac
exit 0
