#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

SYNOINFO_DEF="/etc.defaults/synoinfo.conf"
SUPPORT_USB_VOLUME=`get_key_value $SYNOINFO_DEF support_usb_volume`

if [ "$1" = "start" -o "$1" = "" ]; then
	# Clean up printers section in smb.conf
	/usr/syno/bin/synoprint --disable > /dev/null 2>&1

	if [ "$SUPPORT_USB_VOLUME" != "yes" ]; then
		/usr/syno/bin/synocheckvolume
		rm /tmp/.db.*
		/usr/syno/bin/synocheckshare
		rm /tmp/.db.*
		/usr/syno/bin/synocheckiscsitrg
	fi
fi

UpgradeConfig()
{
	Event=$1
	orgVer="/.old_patch_info/VERSION"
	
	if [ -f "/.updater" ]; then
	    if [ -f $orgVer ]; then
		/.updater -c $Event -p $orgVer
	    else
		echo "Skip update config because not found ${orgVer}"
	    fi
	else
	    echo "Skip update config because not found /.updater" 
	fi
}

#Update config before service start
if [ "$1" = "start" -o "$1" = "" ]; then
    if [ -f "/var/.UpgradeBootup" ]; then
        UpgradeConfig "before_service_start"
        #Sync system notification setting when first time bootup after upgrade
        /usr/syno/bin/notification_utils --sync_setting
    fi
fi

if [ "$1" = "start" -o "$1" = "" ]; then
	/usr/syno/bin/synobootup
fi

